filename out1976 'H:\Private\Poverty Trends\SAS\cps\output\taxsim1976.txt';
filename out1977 'H:\Private\Poverty Trends\SAS\cps\output\taxsim1977.txt';
filename out1978 'H:\Private\Poverty Trends\SAS\cps\output\taxsim1978.txt';
filename out1979 'H:\Private\Poverty Trends\SAS\cps\output\taxsim1979.txt';
filename out1980 'H:\Private\Poverty Trends\SAS\cps\output\taxsim1980.txt';
filename out1981 'H:\Private\Poverty Trends\SAS\cps\output\taxsim1981.txt';
filename out1982 'H:\Private\Poverty Trends\SAS\cps\output\taxsim1982.txt';
filename out1983 'H:\Private\Poverty Trends\SAS\cps\output\taxsim1983.txt';
filename out1984 'H:\Private\Poverty Trends\SAS\cps\output\taxsim1984.txt';
filename out1985 'H:\Private\Poverty Trends\SAS\cps\output\taxsim1985.txt';
filename out1986 'H:\Private\Poverty Trends\SAS\cps\output\taxsim1986.txt';
filename out1987 'H:\Private\Poverty Trends\SAS\cps\output\taxsim1987.txt';

%macro read(surv_yr);

data taxsim&surv_yr;
set cpsdata.all&surv_yr;

/* This is the value for the gross income test for dependents.  It is the same
   as the personal exemption.  
   See data h:data\tax\tax_parameters_taxpolicycenter.org.xls
   The parameters are for tax years 1971-2005--CPS years 1972-2004
*/
	IF &surv_yr=1972 THEN inc_test=675;  
	ELSE IF &surv_yr IN(1973,1974,1975,1976,1977,1978,1979) THEN inc_test=750; 
	ELSE IF &surv_yr IN(1980,1981,1982,1983,1984,1985) THEN inc_test=1000;  
	ELSE IF &surv_yr=1986 THEN inc_test=1040; 
	ELSE IF &surv_yr=1987 THEN inc_test=1080; 
	ELSE IF &surv_yr=1988 THEN inc_test=1900; 
	ELSE IF &surv_yr=1989 THEN inc_test=1950; 
	ELSE IF &surv_yr=1990 THEN inc_test=2000;
	ELSE IF &surv_yr=1991 THEN inc_test=2050;
	ELSE IF &surv_yr=1992 THEN inc_test=2150;
	ELSE IF &surv_yr=1993 THEN inc_test=2300; 
	ELSE IF &surv_yr=1994 THEN inc_test=2350; 
	ELSE IF &surv_yr=1995 THEN inc_test=2450; 
	ELSE IF &surv_yr=1996 THEN inc_test=2500; 
	ELSE IF &surv_yr=1997 THEN inc_test=2550; 
	ELSE IF &surv_yr=1998 THEN inc_test=2650; 
	ELSE IF &surv_yr=1999 THEN inc_test=2700; 
	ELSE IF &surv_yr=2000 THEN inc_test=2750; 
	ELSE IF &surv_yr=2001 THEN inc_test=2800; 
	ELSE IF &surv_yr=2002 THEN inc_test=2900; 
	ELSE IF &surv_yr=2003 THEN inc_test=3000; 
	ELSE IF &surv_yr=2004 THEN inc_test=3050; 


* Creat dependents var, including both children and non-working unmarried relatives;
IF (refrel2 IN(4,5,6) AND famrel IN(0,3,4)) 
			/* don't work at all or work little because you go to school */
			AND (rsnnotw NE 0 OR (wkswrk LE 13 AND rsnnotl=3)) 
			AND marstat GE 5 
			AND ptotinc LT inc_test 
			THEN dep=1;

* allow married non-working children 19-23 to be dependents;
ELSE IF (refrel2 IN(4,5,6) AND famrel IN(0,3,4)) AND 19 LE age LE 23 
			/* don't work at all or work little because you go to school */
			AND (rsnnotw NE 0 OR (wkswrk LE 13 AND rsnnotl=3)) THEN dep=1;

* allow all children under 19 to be dependents;
ELSE IF (refrel2 IN(4,5,6) AND famrel IN(0,3,4)) AND age LE 18 THEN dep=1;
ELSE dep=0;

* calc num of kids for fed child tax credit;
IF (refrel2 IN(4,5,6) AND famrel IN(0,3,4)) AND age LE 16 THEN kids3=1;
ELSE kids3=0;

* calc num of eitc kids;
IF (refrel2 IN(4,5,6) AND famrel IN(0,3,4)) AND age LE 18 THEN kids2=1;
ELSE IF (refrel2 IN(4,5,6) AND famrel IN(0,3,4)) AND 19 LE age LE 23 
			AND (rsnnotw IN(1,3) OR (wkswrk LE 13 AND rsnnotl IN(1,3))) THEN kids2=1;
ELSE kids2=0;

* calc num of taxpayers over 65;
IF age GT 65 AND dep=0 THEN gt65=1;
ELSE gt65=0;

IF (refrel2=3 OR famrel=2) THEN wife_inc=ptotearn;
ELSE wife_inc=0;

run;

proc sort data=taxsim&surv_yr;
by famid;
run;

proc means data=taxsim&surv_yr sum noprint;
by famid;
* restrict to husbands, wives, and their dependents;
where refrel2 IN(1,3) OR famrel IN(1,2) OR dep=1;
var dep kids2 kids3 wife_inc gt65 ssinc intinc divinc uiinc retinc alimony ptotearn;
output out=temp1 sum=totdep kid_eitc kid_fcc tfu_wifi tfu_gt65 tfu_ss tfu_int 
					 tfu_div tfu_ui tfu_ret tfu_alm tfu_earn;
run;

data cpsdata.taxsim&surv_yr;
merge taxsim&surv_yr(IN=in1) temp1(KEEP=famid totdep kid_eitc kid_fcc tfu_wifi tfu_gt65 tfu_ss tfu_int 
					            tfu_div tfu_ui tfu_ret tfu_alm tfu_earn);
by famid;
if in1;

* Restrict sample to heads of tax filing unit;
* Delete spouses;
IF refrel2=3 OR famrel=2 THEN DELETE;
* Delete dependents;
IF dep=0;

     ARRAY tax_vars totdep kid_eitc kid_fcc tfu_wifi tfu_gt65 tfu_ss tfu_int 
					            tfu_div tfu_ui tfu_ret tfu_alm tfu_earn;
	 DO OVER tax_vars;
	 IF tax_vars=. THEN tax_vars=0;
	 END; 

*adjustments for taxsim;
tfu_wifi=MAX(tfu_wifi,0);
totdep=MIN(totdep,15);
kid_eitc=MIN(kid_eitc,15);
kid_fcc=MIN(kid_fcc,15);

IF refrel2=1 OR famrel=1 THEN taxinc=tfu_earn-tfu_wifi;
ELSE taxinc=ptotearn;
taxinc=MAX(taxinc,0);

IF refrel2=1 OR famrel=1 THEN inc9=tfu_div;
ELSE inc9=divinc;
inc9=MAX(inc9,0);

IF refrel2=1 OR famrel=1 THEN inc10=tfu_int;
ELSE inc10=intinc;

IF refrel2=1 OR famrel=1 THEN inc11=tfu_ret;
ELSE inc11=retinc;

IF refrel2=1 OR famrel=1 THEN inc12=tfu_ss;
ELSE inc12=ssinc;

IF refrel2=1 OR famrel=1 THEN inc18=tfu_ui;
ELSE inc18=uiinc;

IF refrel2=1 OR famrel=1 THEN num_gt65=tfu_gt65;
ELSE num_gt65=gt65;

id=pseq*100+ppos;

IF marstat IN(1,2,3,4) THEN filestat=2;
   ELSE IF totdep GT 0 AND marstat GT 4 THEN filestat=3;
   ELSE filestat=1;

***********************************************************
Recode from CPS state id to the SOI state id used by taxsim
***********************************************************;
IF &surv_yr=1976 THEN DO;
IF state2=16 THEN state=7;
ELSE IF state2=14 THEN state=22;
ELSE IF state2=19 THEN state=20;
ELSE IF state2=19 THEN state=20;
ELSE IF state2=19 THEN state=20;
ELSE IF state2=19 THEN state=20;
ELSE IF state2=21 THEN state=33;
ELSE IF state2=22 THEN state=31;
ELSE IF state2=23 THEN state=39;
ELSE IF state2=31 THEN state=36;
ELSE IF state2=32 THEN state=15;
ELSE IF state2=33 THEN state=14;
ELSE IF state2=39 THEN state=23;
ELSE IF state2=39 THEN state=23;
ELSE IF state2=43 THEN state=26;
ELSE IF state2=49 THEN state=24;
ELSE IF state2=49 THEN state=24;
ELSE IF state2=49 THEN state=24;
ELSE IF state2=49 THEN state=24;
ELSE IF state2=49 THEN state=24;
ELSE IF state2=49 THEN state=24;
ELSE IF state2=53 THEN state=9;
ELSE IF state2=56 THEN state=34;
ELSE IF state2=57 THEN state=21;
ELSE IF state2=57 THEN state=21;
ELSE IF state2=57 THEN state=21;
ELSE IF state2=57 THEN state=21;
ELSE IF state2=58 THEN state=11;
ELSE IF state2=58 THEN state=11;
ELSE IF state2=59 THEN state=10;
ELSE IF state2=67 THEN state=43;
ELSE IF state2=67 THEN state=43;
ELSE IF state2=69 THEN state=1;
ELSE IF state2=69 THEN state=1;
ELSE IF state2=72 THEN state=44;
ELSE IF state2=79 THEN state=19;
ELSE IF state2=79 THEN state=19;
ELSE IF state2=79 THEN state=19;
ELSE IF state2=81 THEN state=3;
ELSE IF state2=89 THEN state=6;
ELSE IF state2=89 THEN state=6;
ELSE IF state2=89 THEN state=6;
ELSE IF state2=89 THEN state=6;
ELSE IF state2=89 THEN state=6;
ELSE IF state2=89 THEN state=6;
ELSE IF state2=89 THEN state=6;
ELSE IF state2=92 THEN state=5;
ELSE IF state2=99 THEN state=38;
ELSE IF state2=99 THEN state=38;
ELSE IF state2=99 THEN state=38;
ELSE IF state2=99 THEN state=38;
*6 obs have state=0;
ELSE IF state2=0 AND hreg=1 THEN state=21;
ELSE IF state2=0 AND hreg=2 THEN state=33;
ELSE IF state2=0 AND hreg=3 THEN state=59;
ELSE IF state2=0 AND hreg=4 THEN state=92;

END;


IF 1977 LE &surv_yr LE 1987 THEN DO;
IF state2=11 THEN state=20;
IF state2=12 THEN state=30;
IF state2=13 THEN state=46;
IF state2=14 THEN state=22;
IF state2=15 THEN state=40;
IF state2=16 THEN state=7;
IF state2=21 THEN state=33;
IF state2=22 THEN state=31;
IF state2=23 THEN state=39;
IF state2=31 THEN state=36;
IF state2=32 THEN state=15;
IF state2=33 THEN state=14;
IF state2=34 THEN state=23;
IF state2=35 THEN state=50;
IF state2=41 THEN state=24;
IF state2=42 THEN state=16;
IF state2=43 THEN state=26;
IF state2=44 THEN state=35;
IF state2=45 THEN state=42;
IF state2=46 THEN state=28;
IF state2=47 THEN state=17;
IF state2=51 THEN state=8;
IF state2=52 THEN state=21;
IF state2=53 THEN state=9;
IF state2=54 THEN state=47;
IF state2=55 THEN state=49;
IF state2=56 THEN state=34;
IF state2=57 THEN state=41;
IF state2=58 THEN state=11;
IF state2=59 THEN state=10;
IF state2=61 THEN state=18;
IF state2=62 THEN state=43;
IF state2=63 THEN state=1;
IF state2=64 THEN state=25;
IF state2=71 THEN state=4;
IF state2=72 THEN state=19;
IF state2=73 THEN state=37;
IF state2=74 THEN state=44;
IF state2=81 THEN state=27;
IF state2=82 THEN state=13;
IF state2=83 THEN state=51;
IF state2=84 THEN state=6;
IF state2=85 THEN state=32;
IF state2=86 THEN state=3;
IF state2=87 THEN state=45;
IF state2=88 THEN state=29;
IF state2=91 THEN state=48;
IF state2=92 THEN state=38;
IF state2=93 THEN state=5;
IF state2=94 THEN state=2;
IF state2=95 THEN state=12;

END;

fill=0;


KEEP id ref_year state filestat totdep num_gt65 taxinc tfu_wifi
   inc9 inc10 inc11 inc12 fill inc18 kid_fcc kid_eitc inc_test;
RUN;

PROC MEANS;
RUN;

DATA _NULL_;
   SET cpsdata.taxsim&surv_yr;
   FILE out&surv_yr lrecl=500;
   PUT id ref_year state filestat totdep num_gt65 taxinc tfu_wifi
   inc9 inc10 inc11 inc12 fill fill fill fill fill inc18 kid_fcc fill fill fill;
RUN;

%mend read;

%read(1976);
%read(1977);
%read(1978);
%read(1979);
%read(1980);
%read(1981);
%read(1982);
%read(1983);
%read(1984);
%read(1985);
%read(1986);
%read(1987);
